@extends('layouts.business.master')

@section('title')
    {{ __('Sales List') }}
@endsection

@section('main_content')
    <div class="erp-table-section">
        <div class="container-fluid">
            <div class="card">
                <div class="card-bodys">
                    <div class="table-header p-16">
                        <h4>{{ __('Sales List') }}</h4>
                    </div>
                    <div class="table-top-form p-16-0">
                        <div class="d-flex align-items-center gap-3 flex-wrap margin-lr-16">
                            <form action="{{ route('business.sales.filter') }}" method="post" class="report-filter-form" table="#sales-data">
                                @csrf
                                <div class="table-top-left d-flex gap-3 flex-wrap">

                                    <div class="gpt-up-down-arrow position-relative">
                                        <select name="per_page" class="form-control">
                                            <option value="10">{{ __('Show- 10') }}</option>
                                            <option value="25">{{ __('Show- 25') }}</option>
                                            <option value="50">{{ __('Show- 50') }}</option>
                                            <option value="100">{{ __('Show- 100') }}</option>
                                        </select>
                                        <span></span>
                                    </div>

                                    @if(auth()->user()->accessToMultiBranch())
                                    <div class="table-search position-relative">
                                        <div class="gpt-up-down-arrow position-relative">
                                        <select name="branch_id" class="form-control">
                                            <option value="">{{ __('Select Branch') }}</option>
                                            @foreach ($branches as $branch)
                                                <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                                            @endforeach
                                        </select>
                                        <span></span>
                                        </div>
                                    </div>
                                    @endif

                                    <div class="table-search position-relative">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="{{ __('Search...') }}">
                                        <span class="position-absolute">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14.582 14.582L18.332 18.332" stroke="#4D4D4D" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M16.668 9.16797C16.668 5.02584 13.3101 1.66797 9.16797 1.66797C5.02584 1.66797 1.66797 5.02584 1.66797 9.16797C1.66797 13.3101 5.02584 16.668 9.16797 16.668C13.3101 16.668 16.668 13.3101 16.668 9.16797Z" stroke="#4D4D4D" stroke-width="1.25" stroke-linejoin="round"/>
                                            </svg>
                                        </span>
                                    </div>

                                        <div class="custom-from-to align-items-center date-filters d-none">
                                            <label class="header-label">{{ __('From Date') }}</label>
                                            <input type="date" name="from_date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}" class="form-control">
                                        </div>
                                        <div class="custom-from-to align-items-center date-filters d-none">
                                            <label class="header-label">{{ __('To Date') }}</label>
                                            <input type="date" name="to_date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}" class="form-control">
                                        </div>
                                        <div class="gpt-up-down-arrow position-relative d-print-none custom-date-filter">
                                            <select name="custom_days" class="form-control custom-days">
                                                <option value="today">{{__('Today')}}</option>
                                                <option value="yesterday">{{__('Yesterday')}}</option>
                                                <option value="last_seven_days">{{__('Last 7 Days')}}</option>
                                                <option value="last_thirty_days">{{__('Last 30 Days')}}</option>
                                                <option value="current_month">{{__('Current Month')}}</option>
                                                <option value="last_month">{{__('Last Month')}}</option>
                                                <option value="current_year">{{__('Current Year')}}</option>
                                                <option value="custom_date">{{__('Custom Date')}}</option>
                                            </select>
                                            <span></span>
                                            <div class="calendar-icon">
                                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12.6667 2.66797H3.33333C2.59695 2.66797 2 3.26492 2 4.0013V13.3346C2 14.071 2.59695 14.668 3.33333 14.668H12.6667C13.403 14.668 14 14.071 14 13.3346V4.0013C14 3.26492 13.403 2.66797 12.6667 2.66797Z" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M10.666 1.33203V3.9987" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M5.33398 1.33203V3.9987" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M2 6.66797H14" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                            </div>
                                        </div>

                                </div>
                            </form>

                        </div>
                    </div>
                </div>

                <div class="delete-item delete-show d-none">
                    <div class="delete-item-show">
                        <p class="fw-bold"><span class="selected-count"></span> {{ __('items show') }}</p>
                        <button data-bs-toggle="modal" class="trigger-modal" data-bs-target="#multi-delete-modal" data-url="{{ route('business.sales.delete-all') }}">{{ __('Delete') }}</button>
                    </div>
                </div>

                <div class="responsive-table m-0">
                    <table class="table" id="datatable">
                        <thead>
                            <tr>
                                @usercan('sales.delete')
                                <th class="w-60">
                                    <div class="d-flex align-items-center gap-3">
                                        <input type="checkbox" class="select-all-delete multi-delete ">
                                    </div>
                                </th>
                                @endusercan
                                <th>{{ __('SL') }}.</th>
                                <th class="text-start">{{ __('Date') }}</th>
                                @if(auth()->user()->accessToMultiBranch())
                                <th class="text-start">{{ __('Branch') }}</th>
                                @endif
                                <th class="text-start">{{ __('Invoice No') }}</th>
                                <th class="text-start">{{ __('Party Name') }}</th>
                                <th class="text-start">{{ __('Total') }}</th>
                                <th class="text-start">{{ __('Discount') }}</th>
                                <th class="text-start">{{ __('Paid') }}</th>
                                <th class="text-start">{{ __('Due') }}</th>
                                <th class="text-start">{{ __('Payment') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody id="sales-data">
                            @include('business::sales.datas')
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $sales->links('vendor.pagination.bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('modal')
    @include('business::component.delete-modal')
@endpush
